{------------------------------------------------------------------------------}
{- Program    : UTTEST.PAS                                                    -}
{- Programmer : Todd Fiske                                                    -}
{-                                                                            -}
{- Purpose    : Test the UNIXTIME.PAS unit                                    -}
{-                                                                            -}
{- Revision   : 02/17/1994 - first version                                    -}
{- History      01/16/1995 - cleaned up for uploading                         -}
{-                                                                            -}
{- Language   : Turbo Pascal 7.0                                              -}
{-                                                                            -}
{------------------------------------------------------------------------------}
program uttest;

uses
   dos,
   unixtime;

var
   t : longint;
   d : DateTime;
   f : file;

begin
   writeln;
   writeln('UnixTime Test');

   if paramcount = 0 then begin
      writeln;
      writeln('uttest <timelongint>');
      halt;
   end;

   writeln;
   writeln('Unpacking Unix time longint');

   t := str2int(paramstr(1));
   UnpackUnixTime(t, d);

   writeln;
   writeln('year      : ', d.year  : 4);
   writeln('month     : ', d.month : 4);
   writeln('day       : ', d.day   : 4);
   writeln('hour      : ', d.hour  : 4);
   writeln('minute    : ', d.min   : 4);
   writeln('second    : ', d.sec   : 4);

   writeln;
   writeln('formatted : ', FormatUnixTime(t));

   writeln;
   PackUnixTime(d, t);
   writeln('repacked  : ', t);

   (**
   PackTime(d, t);
   writeln;
   writeln('packed    : ', t);

   assign(f, 'uttest.pas');
   reset(f);
   GetFTime(f, t);
   close(f);

   writeln('today     : ', t);
   **)
end.
